#!/usr/bin/env perl

# ace-to-sam_wrapper.pl
# MacVector
#
# Created by B. Kevin Hardman on 12/29/11
# Copyright © 2011 MacVector, Inc. All rights reserved.

use POSIX qw(setsid);
setsid;
$SIG{INT} = \&process_signal_INT;

use Getopt::Long;

my $aceFile;
my $basename;
my $consensus;
my $index;
my $path;
my $qualityFile;
my $statistics;
my $test;
my $verbose;
my $workingDirectory = "/tmp/macvector/ace-to-sam";
my $result = GetOptions(
	"acefile=s" => \$aceFile,
	"basename=s" => \$basename,
	"consensus=s" => \$consensus,
	"index=s" => \$index,
	"path=s" => \$path,
	"qualityfile=s" => \$qualityFile,
	"statisticsfile=s" => \$statistics,
	"test" => \$test,
	"verbose" => \$verbose,
	"working_directory=s" => \$workingDirectory
);

my $indexArguments;
$indexArguments = " -c" if $index =~ /^csi$/i;

chdir "$workingDirectory";

$ENV{PYTHONDONTWRITEBYTECODE} = "1";

# convert ace to bam
print STDERR qq{"$path/ace-to-sam.py" -i "$aceFile" -q "$qualityFile" -o - -c "$consensus" -s "$statistics" | "$path/samtools" view -bS -F 4 -o $basename.bam -\n} if $verbose;
print STDOUT qx{"$path/ace-to-sam.py" -i "$aceFile" -q "$qualityFile" -o - -c "$consensus" -s "$statistics" | "$path/samtools" view -bS -F 4 -o $basename.bam -} if !$test;

# sort and index bam
print STDERR qq{"$path/samtools" sort $basename.bam -o $basename-sorted.bam\n} if $verbose;
print STDOUT qx{"$path/samtools" sort $basename.bam -o $basename-sorted.bam} if !$test;
print STDERR qq{"$path/samtools" index$indexArguments $basename-sorted.bam\n} if $verbose;
print STDOUT qx{"$path/samtools" index$indexArguments $basename-sorted.bam} if !$test;

sub process_signal_INT {
	kill "TERM", -$$;
	die "Process interrupted.\n";
}

__END__

print STDERR qq{\n} if $verbose;
print STDOUT qx{} if !$test;
