#!/usr/bin/env perl

# amos-to-bam_wrapper.pl
# MacVector
#
# Created by Kevin Kendall on 10/7/13
# Copyright © 2013 MacVector, Inc. All rights reserved.

use POSIX qw(setsid);
setsid;
$SIG{INT} = \&process_signal_INT;

use Getopt::Long;

my $amosfile;
my $basename;
my $index;
my $path;
my $test;
my $verbose;
my $workingDirectory = "/tmp/macvector/amos";
my $result = GetOptions(
	"amosfile=s" => \$amosfile,
	"basename=s" => \$basename,
	"index=s" => \$index,
	"path=s" => \$path,
	"test" => \$test,
	"verbose" => \$verbose,
	"working_directory=s" => \$workingDirectory
);

my $indexArguments;
$indexArguments = " -c" if $index =~ /^csi$/i;

chdir "$workingDirectory";

# convert amos to bam
# step 1 - create the bank file
# bank-transact -m data.afg -b data.bnk -c

print STDERR "bank-transact = $path/bank-transact \n";
print STDERR "workingDirectory = $workingDirectory \n";
print STDERR "Basename = $basename \n";
print STDERR "Amosfile = $amosfile \n";
print STDERR "$basename.bnk \n";

print STDERR qq{"$path/bank-transact" -m "$amosfile" -b $basename.bnk -c\n} if $verbose;
print STDOUT qx{"$path/bank-transact" -m "$amosfile" -b $basename.bnk -c} if !$test;

# step 2 - create the fasta file with the contig consensus seqs
# bank2fasta -i -b data.bnk > data.fa
print STDERR qq{"$path/bank2fasta" -i -b $basename.bnk > $basename.fa\n} if $verbose;
print STDOUT qx{"$path/bank2fasta" -i -b $basename.bnk > $basename.fa} if !$test;

# step 3 - create the bam file with the read data
#bank2contig -i -s Velvet.bnk | samtools view -bT Velvet.fa - | samtools sort - SortedOutput.bam
print STDERR qq{"$path/bank2contig" -i -s $basename.bnk | "$path/samtools" view -bT $basename.fa - | "$path/samtools" sort - -o $basename-sorted.bam\n} if $verbose;
print STDOUT qx{"$path/bank2contig" -i -s $basename.bnk | "$path/samtools" view -bT $basename.fa - | "$path/samtools" sort - -o $basename-sorted.bam} if !$test;

# step 4 - sort and index bam
#print STDERR qq{"$path/samtools" sort $basename.bam $basename-sorted\n} if $verbose;
#print STDOUT qx{"$path/samtools" sort $basename.bam $basename-sorted} if !$test;
print STDERR qq{"$path/samtools" index$indexArguments $basename-sorted.bam\n} if $verbose;
print STDOUT qx{"$path/samtools" index$indexArguments $basename-sorted.bam} if !$test;

sub process_signal_INT {
	kill "TERM", -$$;
	die "Process interrupted.\n";
}

__END__

print STDERR qq{\n} if $verbose;
print STDOUT qx{} if !$test;
