#!/usr/bin/env perl

# bam_import.pl
# MacVector
#
# Created by B. Kevin Hardman on 02/10/12
# Copyright © 2012 MacVector, Inc. All rights reserved.

use POSIX qw(setsid);
setsid;
$SIG{INT} = \&process_signal_INT;

use Getopt::Long;

my $basename;
my $consensus;
my $index;
my $inputBAMFile;
my $path;
my @references;
my $sort;
my $test;
my $verbose;
my $workingDirectory = "/tmp/macvector/bam_import";
my $result = GetOptions(
	"basename=s" => \$basename,
	"consensus" => \$consensus,
	"index=s" => \$index,
	"input=s" => \$inputBAMFile,
	"path=s" => \$path,
	"reference=s" => \@references,
	"sort" => \$sort,
	"test" => \$test,
	"verbose" => \$verbose,
	"working_directory=s" => \$workingDirectory
);

$index = "bai" if !$index;

my $indexArguments;
$indexArguments = " -c" if $index =~ /^csi$/i;

# build reference argument and create reference sequence indices
my $referenceArgument;
foreach my $reference (@references) {
	$referenceArgument .= "$reference,";

	print STDERR qq{"$path/samtools" faidx "$reference"\n} if $verbose;
	print STDOUT qx{"$path/samtools" faidx "$reference"} if !$test;
}
chop $referenceArgument;

chdir "$workingDirectory";

if ($sort) {
	if (!-e "$inputBAMFile.$index" || (-M "$inputBAMFile" > -M "$inputBAMFile.$index")) {
		# sort and index bam
		print STDERR qq{"$path/samtools" sort "$inputBAMFile" -o $basename-sorted.bam\n} if $verbose;
		print STDOUT qx{"$path/samtools" sort "$inputBAMFile" -o $basename-sorted.bam} if !$test;
		print STDERR qq{"$path/samtools" index$indexArguments $basename-sorted.bam\n} if $verbose;
		print STDOUT qx{"$path/samtools" index$indexArguments $basename-sorted.bam} if !$test;
	}

	if (!-e "$basename-sorted.bam") {
		print STDERR qq{ln -s "$inputBAMFile" $basename-sorted.bam\n} if $verbose;
		print STDOUT qx{ln -s "$inputBAMFile" $basename-sorted.bam} if !$test;
		print STDERR qq{ln -s "$inputBAMFile.$index" $basename-sorted.bam.$index\n} if $verbose;
		print STDOUT qx{ln -s "$inputBAMFile.$index" $basename-sorted.bam.$index} if !$test;
	}
}

if ($consensus) {
	print STDERR qq{"$path/samtools-mv13" mpileup -u $basename-sorted.bam | "$path/bcftools-mv13" view -cg - | "$path/vcfutils.pl" vcf2fq > "$basename-consensus.fq"\n} if $verbose;
	print STDOUT qx{"$path/samtools-mv13" mpileup -u $basename-sorted.bam | "$path/bcftools-mv13" view -cg - | "$path/vcfutils.pl" vcf2fq > "$basename-consensus.fq"} if !$test;
}

sub process_signal_INT {
	kill "TERM", -$$;
	die "Process interrupted.\n";
}

__END__

print STDERR qq{\n} if $verbose;
print STDOUT qx{} if !$test;
