#!/usr/bin/env perl

# cross_match_wrapper.pl
# MacVector
#
# Created by B. Kevin Hardman on 02/29/12
# Copyright © 2012 MacVector, Inc. All rights reserved.

use POSIX qw(setsid);
setsid;
$SIG{INT} = \&process_signal_INT;

use Getopt::Long;

my $arguments;
my $path;
my $test;
my $verbose;
my $workingDirectory = "/tmp/macvector/bowtie";
my $result = GetOptions(
	"arguments=s" => \$arguments,
	"path=s" => \$path,
	"test" => \$test,
	"verbose" => \$verbose,
	"working_directory=s" => \$workingDirectory
);

chdir "$workingDirectory";

# run cross_match which as a limit on path lengths (100) so always cd to the workign directory and use relative file names
print STDERR qq{"$path/cross_match" XMatchJob XMatchJob.Vectors -screen$arguments\n} if $verbose;
print STDOUT qx{"$path/cross_match" XMatchJob XMatchJob.Vectors -screen$arguments} if !$test;

sub process_signal_INT {
	kill "TERM", -$$;
	die "Process interrupted.\n";
}

__END__

print STDERR qq{\n} if $verbose;
print STDOUT qx{} if !$test;
