#!/usr/bin/env perl

# samtools_wrapper.pl
# MacVector
#
# Created by B. Kevin Hardman on 5/25/11.
# Copyright © 2011 MacVector, Inc. All rights reserved.

use POSIX qw(setsid);
setsid;
$SIG{INT} = \&process_signal_INT;

use List::Util 'max';

use Getopt::Long;

my $basename;
my $coverage;
my $depth;
my $input;
my $path;
my @references;
my $vcfReport;
my $test;
my $verbose;
my $workingDirectory = "/tmp/macvector/bowtie";
my $result = GetOptions(
	"basename=s" => \$basename,
	"coverage=s" => \$coverage,
	"depth=s" => \$depth,
	"input=s" => \$input,
	"path=s" => \$path,
	"reference=s" => \@references,
	"snp=s" => \$vcfReport,
	"test" => \$test,
	"verbose" => \$verbose,
	"working_directory=s" => \$workingDirectory
);

chdir "$workingDirectory";

if ($coverage) {
	my $nextIndex = 1;

	# get coverage data for reference sequence
	print STDERR qq{"$path/bcftools" mpileup --max-depth $depth -r "$coverage" --no-reference $basename-sorted.bam\n} if $verbose;
	open FILE, "-|", qq{"$path/bcftools" mpileup --max-depth $depth -r "$coverage" --no-reference $basename-sorted.bam};
	while (<FILE>) {
		next if /^#/;
		my ($name, $index, $base, $ref, $alt, $qual, $filter, $info, $format, $extra) = split(/\t/);
		if ($index != $nextIndex) {
			while ($nextIndex < $index) {
				print "0\n";
				++$nextIndex;
			}
		}
		my ($count) = ($info =~ /DP=(\d+)/, 0);
		print "$count\n";
		++$nextIndex;
	}
	close FILE;
}

if ($vcfReport && !$input) {
	foreach my $reference (@references) {
		print STDERR qq{"$path/bcftools" mpileup --max-depth $depth -r "$vcfReport" -f "$reference" $basename-sorted.bam | "$path/bcftools" call -cv - | "$path/vcfutils.pl" varFilter\n} if $verbose;
		print STDOUT qx{"$path/bcftools" mpileup --max-depth $depth -r "$vcfReport" -f "$reference" $basename-sorted.bam | "$path/bcftools" call -cv - | "$path/vcfutils.pl" varFilter} if !$test;
	}
}

if ($vcfReport && $input) {
	foreach my $reference (@references) {
		print STDERR qq{"$path/samtools" faidx "$reference"\n} if $verbose;
		print STDOUT qx{"$path/samtools" faidx "$reference"} if !$test;

		print STDERR qq{"$path/bcftools" mpileup --max-depth $depth -r "$vcfReport" -f "$reference" "$input" | "$path/bcftools" call -cv - | "$path/vcfutils.pl" varFilter\n} if $verbose;
		print STDOUT qx{"$path/bcftools" mpileup --max-depth $depth -r "$vcfReport" -f "$reference" "$input" | "$path/bcftools" call -cv - | "$path/vcfutils.pl" varFilter} if !$test;
	}
}

sub process_signal_INT {
	kill "TERM", -$$;
	die "Process interrupted.\n";
}

__END__

print STDERR qq{\n} if $verbose;
print STDOUT qx{} if !$test;
