#!/usr/bin/env perl

# primer3_tabulate.pl
# MacVector
#
# Created by B. Kevin Hardman on 11/27/07.
# Copyright © 2007 MacVector, Inc. All rights reserved.

my $s = ",";

my $seen = 0;
my $seenInternal = 0;

my %records;

while (<STDIN>) {
	my $rank = 0;
	($rank = $1) if (/^PRIMER_.*?_(\d+).*?=/);
	$records{$rank} = {
		L_START => 0, L_LENGTH => 0, L_TM => 0.0, L_GC => 0.0, L_SEQUENCE => "",
		R_START => 0, R_LENGTH => 0, R_TM => 0.0, R_GC => 0.0, R_SEQUENCE => "",
		P_SIZE => 0, P_TM => 0.0, P_TM_DIFF => 0.0, P_TM_OPT_A => 0.0,
		I_START => 0, I_LENGTH => 0, I_TM => 0.0, I_GC => 0.0, I_SEQUENCE => ""
	} if (!exists $records{$rank});

	my $record = $records{$rank};
	($$record{"L_START"}, $$record{"L_LENGTH"}, $seen) = ($1, $2, 1) if /^PRIMER_LEFT_\d+=(-?\d+),(\d+)$/i;
	($$record{"L_TM"}, $seen) = ($1, 1) if /^PRIMER_LEFT_\d+_TM=([.\d+]*)$/i;
	($$record{"L_GC"}, $seen) = ($1, 1) if /^PRIMER_LEFT_\d+_GC_PERCENT=([.\d+]*)$/i;
	($$record{"L_SEQUENCE"}, $seen) = ($1, 1) if /^PRIMER_LEFT_\d+_SEQUENCE=(.*)$/i;
	($$record{"R_START"}, $$record{"R_LENGTH"}, $seen) = ($1, $2, 1) if /^PRIMER_RIGHT_\d+=(-?\d+),(\d+)$/i;
	($$record{"R_TM"}, $seen) = ($1, 1) if /^PRIMER_RIGHT_\d+_TM=([.\d+]*)$/i;
	($$record{"R_GC"}, $seen) = ($1, 1) if /^PRIMER_RIGHT_\d+_GC_PERCENT=([.\d+]*)$/i;
	($$record{"R_SEQUENCE"}, $seen) = ($1, 1) if /^PRIMER_RIGHT_\d+_SEQUENCE=(.*)$/i;
	($$record{"P_SIZE"}, $seen) = ($1, 1) if /^PRIMER_PAIR_\d+_PRODUCT_SIZE=(\d+)$/i;
	($$record{"P_TM"}, $seen) = ($1, 1) if /^PRIMER_PAIR_\d+_PRODUCT_TM=([.\d+]*)$/i;
	($$record{"P_TM_OPT_A"}, $seen) = ($1, 1) if /^PRIMER_PAIR_\d+_T_OPT_A=([.\d+]*)$/i;
	($$record{"I_START"}, $$record{"I_LENGTH"}, $seenInternal) = ($1, $2, 1) if /^PRIMER_INTERNAL_\d+=(-?\d+),(\d+)$/i;
	($$record{"I_TM"}, $seenInternal) = ($1, 1) if /^PRIMER_INTERNAL_\d+_TM=([.\d+]*)$/i;
	($$record{"I_GC"}, $seenInternal) = ($1, 1) if /^PRIMER_INTERNAL_\d+_GC_PERCENT=([.\d+]*)$/i;
	($$record{"I_SEQUENCE"}, $seenInternal) = ($1, 1) if /^PRIMER_INTERNAL_\d+_SEQUENCE=(.*)$/i;
}

if ($seen) {
	my $header = "Rank${s}L Start${s}L Len${s}L Tm${s}L GC%${s}L Sequence${s}R Start${s}R Len${s}R Tm${s}R GC%${s}R Sequence${s}P Size${s}P Tm${s}Ta";
	$header .= "${s}H Start${s}H Len${s}H Tm${s}H GC%${s}H Sequence" if ($seenInternal);
	print "$header\n";

	foreach my $rank (sort { $a <=> $b } keys %records) {
		my $record = $records{$rank};
		my $tabulated = $rank
			. "$s" . $$record{"L_START"} . "$s" . $$record{"L_LENGTH"} . "$s" . $$record{"L_TM"} . "$s" . $$record{"L_GC"} . "$s" . $$record{"L_SEQUENCE"}
			. "$s" . $$record{"R_START"} . "$s" . $$record{"R_LENGTH"} . "$s" . $$record{"R_TM"} . "$s" . $$record{"R_GC"} . "$s" . $$record{"R_SEQUENCE"}
			. "$s" . $$record{"P_SIZE"} . "$s" . $$record{"P_TM"} . "$s" . $$record{"P_TM_OPT_A"};
		$tabulated .= "$s" . $$record{"I_START"} . "$s" . $$record{"I_LENGTH"} . "$s" . $$record{"I_TM"} . "$s" . $$record{"I_GC"} . "$s" . $$record{"I_SEQUENCE"} if ($seenInternal);
		print "$tabulated\n";
	}
}

__END__
